

//this is a linear block coding and decoding over awgn channel
// 4 bits input signal is coded with linear block code (4,7), 7 bit coded signal is transmitted over awgn channel and at receiver side signal is decoded. If there is error in one bit, li//near block code correct that error and original transmitter code is receved.
//If error is in more than one bit, code is not corrected so wrong code is recieved
clc;
clear all;
xdel(winsid());
global P n k;

n=7;//length of coded input
k=4;//length of input
P=[1 1 0; 0 1 1; 1 0 1;1 1 1]; //parity  matrix of size k*(n-k) to be 
//                               selected so that the systematic generator   
//                               matrix is linearly independent or full rank 
//                               matrix

//(n,k) linear block code where k - no. of input data bits and n-no. of o/p
//data bits. code rate=k/n
// x is an input vector containing k bits 

//This is an linear block encoding function 
function y1=linblkcode(x);
global P n k;
n=7;
k=4;
P=[1 1 0; 0 1 1; 1 0 1;1 1 1];//parity matrix
//x=[0 1 1 0];

//G=[ ];	//		% Generator matrix k*n
G=[eye(k,k) P]; 

y1=zeros(1,n);
for i=1:k//linear block coding
    var(i,:)=x(1,i) & G(i,:);           
    var(i,:)=bool2s(var(i,:));
    y1(1,:)=bitxor(var(i,:),y1(1,:));//coded signal
end

endfunction


//%This is a linear block syndrome decoding function file%

function x1=linblkdecoder(y)
//% here y is recieved vector 7 bits long
 
//% (7,4) linear block code 
global P n k;

 
//H=[ ]; //% PARITY CHECK MATRIX 
 
H=[P' eye((n-k),(n-k))];
Ht=H'; //%transpose of H
 
S=zeros(1,n-k); //%syndrome of recieved vector x
for i=1:n-k// decoding of linear block code
    S(i)=y(1) & Ht(1,i);
    S(i)=bool2s(S(i));
    for j=2:n
        
        S(i)=bitxor(S(i), bool2s((y(j) & Ht(j,i))));//decoded signal
    end
end


 
//%%****SYNDROME LOOK UP TABLE************
 
//%%**************************************
//% 
if S==[0 0 0]
   e=[0 0 0 0 0 0 0];
    z=bitxor(y,e);
end
 
if S==[0 0 1]
   e=[0 0 0 0 0 0 1];
    z=bitxor(y,e);
end
if S==[0 1 0]
   e=[0 0 0 0 0 1 0];
    z=bitxor(y,e);
end
if S==[1 0 0]
   e=[0 0 0 0 1 0 0];
    z=bitxor(y,e);
end
if S==[1 1 1]
   e=[0 0 0 1 0 0 0];
    z=bitxor(y,e);
end
if S==[1 0 1]
   e=[0 0 1 0 0 0 0];
    z=bitxor(y,e);
end
if S==[0 1 1]
   e=[0 1 0 0 0 0 0];
    z=bitxor(y,e);
end
if S==[1 1 0]
   e=[1 0 0 0 0 0 0];
    z=bitxor(y,e);
end
//disp('error');
//disp(e);
x1=z(1,1:k);
endfunction
snr_dB=2;
 
x=[1 0 0 1];   //                input bits to the encoder of size 1* k
y1=linblkcode(x);//           //   y1 is the output of linear block encoder
n1 = 1/sqrt(2)*[rand(1,length(y1),'normal') + %i*rand(1,length(y1),'normal')];//white gaussian noise generation
r=y1+ 10^(-snr_dB/20)*n1;//received signal over awgn channel
//r1=real(r)
rec=real(r)>=0.5;//detection of bit 1 and 0 in received signal
rec_fin=bool2s(rec);//convert boolean matrix to zero one matrix
//rec_err=rec_fin==y1;
//no_err=bool2s(rec_err);
disp('The information signal=')//display input
disp(x)
disp('The transmitted encoded signal=')//display coded signal
disp(y1)
disp('The recieved signal=')//display received signal
disp(rec_fin);
x1=linblkdecoder(rec_fin); //           % x1 is the output of the linear block decoder
disp('The decoded signal=')//display decoded signal
disp(x1);
if x1==x then disp('one or less than one error so correct code is received');
else
    disp('more than one error so wrong code detected');
end
//Output: The information signal is : 1001
//transmitted code is : 1001001
//1. received signal is :1011001(e.g)(error in only one bit) 
//decoded signal: 1001
//one or less than one error so correct code is received
//2. received signal is:1011011(e.g)(error in more than one bits)
//decoded signal:1010
//more than one error so wrong code is received





